/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.url;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.math.MathHelper;
import com.helger.commons.random.RandomHelper;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.commons.url.URLParameter;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IURLParameterList<IMPLTYPE extends IURLParameterList<IMPLTYPE>>
extends IGenericImplTrait<IMPLTYPE> {
    public boolean add(@Nonnull URLParameter var1);

    @Nonnull
    default public IMPLTYPE add(@Nonnull @Nonempty String string) {
        return this.add(string, (String)null);
    }

    @Nonnull
    default public IMPLTYPE add(@Nonnull Map.Entry<String, String> entry) {
        return this.add(entry.getKey(), entry.getValue());
    }

    @Nonnull
    default public IMPLTYPE add(@Nonnull @Nonempty String string, boolean bl) {
        return this.add(string, Boolean.toString(bl));
    }

    @Nonnull
    default public IMPLTYPE add(@Nonnull @Nonempty String string, int n) {
        return this.add(string, Integer.toString(n));
    }

    @Nonnull
    default public IMPLTYPE add(@Nonnull @Nonempty String string, long l) {
        return this.add(string, Long.toString(l));
    }

    @Nonnull
    default public IMPLTYPE add(@Nonnull @Nonempty String string, @Nullable BigInteger bigInteger) {
        return this.add(string, bigInteger == null ? null : bigInteger.toString());
    }

    @Nonnull
    default public IMPLTYPE add(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.add(new URLParameter(string, string2 != null ? string2 : ""));
        return (IMPLTYPE)((IURLParameterList)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addRandom(@Nonnull @Nonempty String string) {
        return this.add(string, MathHelper.abs(RandomHelper.getRandom().nextLong()));
    }

    @Nonnull
    default public IMPLTYPE addIf(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull Predicate<? super String> predicate) {
        if (predicate.test(string2)) {
            this.add(string, string2);
        }
        return (IMPLTYPE)((IURLParameterList)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addIfNotNull(@Nonnull @Nonempty String string, @Nullable String string2) {
        if (string2 != null) {
            this.add(string, string2);
        }
        return (IMPLTYPE)((IURLParameterList)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addAll(@Nullable Map<String, String> map) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.add(entry);
            }
        }
        return (IMPLTYPE)((IURLParameterList)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addAll(@Nullable List<? extends URLParameter> list) {
        if (list != null) {
            for (URLParameter uRLParameter : list) {
                this.add(uRLParameter);
            }
        }
        return (IMPLTYPE)((IURLParameterList)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addAll(@Nonnull @Nonempty String string, String ... stringArray) {
        if (stringArray != null) {
            for (String string2 : stringArray) {
                this.add(string, string2);
            }
        }
        return (IMPLTYPE)((IURLParameterList)this.thisAsT());
    }
}

