/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.datepicker;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.NotSupported;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;

@Tag(value="vaadin-date-picker")
@HtmlImport(value="frontend://bower_components/vaadin-date-picker/src/vaadin-date-picker.html")
@NpmPackage(value="@vaadin/vaadin-date-picker", version="4.0.8")
@JsModule(value="@vaadin/vaadin-date-picker/src/vaadin-date-picker.js")
public abstract class GeneratedVaadinDatePicker<R extends GeneratedVaadinDatePicker<R, T>, T>
extends AbstractSinglePropertyField<R, T>
implements HasStyle,
Focusable<R> {
    protected boolean isAutofocusBoolean() {
        return this.getElement().getProperty("autofocus", false);
    }

    protected void setAutofocus(boolean autofocus) {
        this.getElement().setProperty("autofocus", autofocus);
    }

    protected boolean isDisabledBoolean() {
        return this.getElement().getProperty("disabled", false);
    }

    protected void setDisabled(boolean disabled) {
        this.getElement().setProperty("disabled", disabled);
    }

    protected boolean isRequiredBoolean() {
        return this.getElement().getProperty("required", false);
    }

    protected void setRequired(boolean required) {
        this.getElement().setProperty("required", required);
    }

    protected String getNameString() {
        return this.getElement().getProperty("name");
    }

    protected void setName(String name) {
        this.getElement().setProperty("name", name == null ? "" : name);
    }

    protected String getInitialPositionString() {
        return this.getElement().getProperty("initialPosition");
    }

    protected void setInitialPosition(String initialPosition) {
        this.getElement().setProperty("initialPosition", initialPosition == null ? "" : initialPosition);
    }

    protected String getLabelString() {
        return this.getElement().getProperty("label");
    }

    protected void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    protected boolean isOpenedBoolean() {
        return this.getElement().getProperty("opened", false);
    }

    protected void setOpened(boolean opened) {
        this.getElement().setProperty("opened", opened);
    }

    protected boolean isShowWeekNumbersBoolean() {
        return this.getElement().getProperty("showWeekNumbers", false);
    }

    protected void setShowWeekNumbers(boolean showWeekNumbers) {
        this.getElement().setProperty("showWeekNumbers", showWeekNumbers);
    }

    protected JsonObject getI18nJsonObject() {
        return (JsonObject)this.getElement().getPropertyRaw("i18n");
    }

    protected void setI18n(JsonObject i18n) {
        this.getElement().setPropertyJson("i18n", (JsonValue)i18n);
    }

    protected String getMinAsStringString() {
        return this.getElement().getProperty("min");
    }

    protected void setMinAsString(String minAsString) {
        this.getElement().setProperty("min", minAsString == null ? "" : minAsString);
    }

    protected String getMaxAsStringString() {
        return this.getElement().getProperty("max");
    }

    protected void setMaxAsString(String maxAsString) {
        this.getElement().setProperty("max", maxAsString == null ? "" : maxAsString);
    }

    protected boolean isClearButtonVisibleBoolean() {
        return this.getElement().getProperty("clearButtonVisible", false);
    }

    protected void setClearButtonVisible(boolean clearButtonVisible) {
        this.getElement().setProperty("clearButtonVisible", clearButtonVisible);
    }

    protected String getErrorMessageString() {
        return this.getElement().getProperty("errorMessage");
    }

    protected void setErrorMessage(String errorMessage) {
        this.getElement().setProperty("errorMessage", errorMessage == null ? "" : errorMessage);
    }

    protected String getPlaceholderString() {
        return this.getElement().getProperty("placeholder");
    }

    protected void setPlaceholder(String placeholder) {
        this.getElement().setProperty("placeholder", placeholder == null ? "" : placeholder);
    }

    protected boolean isReadonlyBoolean() {
        return this.getElement().getProperty("readonly", false);
    }

    protected void setReadonly(boolean readonly) {
        this.getElement().setProperty("readonly", readonly);
    }

    protected boolean isInvalidBoolean() {
        return this.getElement().getProperty("invalid", false);
    }

    protected void setInvalid(boolean invalid) {
        this.getElement().setProperty("invalid", invalid);
    }

    protected void open() {
        this.getElement().callFunction("open", new Serializable[0]);
    }

    protected void close() {
        this.getElement().callFunction("close", new Serializable[0]);
    }

    @NotSupported
    protected void validate(String value) {
    }

    @NotSupported
    protected void checkValidity(String value) {
    }

    protected Registration addChangeListener(ComponentEventListener<ChangeEvent<R>> listener) {
        return this.addListener(ChangeEvent.class, listener);
    }

    protected Registration addInvalidChangeListener(ComponentEventListener<InvalidChangeEvent<R>> listener) {
        return this.getElement().addPropertyChangeListener("invalid", (PropertyChangeListener & Serializable)event -> listener.onComponentEvent(new InvalidChangeEvent<GeneratedVaadinDatePicker>(this, event.isUserOriginated())));
    }

    protected Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent<R>> listener) {
        return this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> listener.onComponentEvent(new OpenedChangeEvent<GeneratedVaadinDatePicker>(this, event.isUserOriginated())));
    }

    protected void addToPrefix(Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("slot", "prefix");
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    protected void remove(Component ... components) {
        for (Component component : components) {
            if (!this.getElement().equals((Object)component.getElement().getParent())) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            component.getElement().removeAttribute("slot");
            this.getElement().removeChild(new Element[]{component.getElement()});
        }
    }

    protected void removeAll() {
        this.getElement().getChildren().forEach(child -> child.removeAttribute("slot"));
        this.getElement().removeAllChildren();
    }

    public <P> GeneratedVaadinDatePicker(T initialValue, T defaultValue, Class<P> elementPropertyType, SerializableFunction<P, T> presentationToModel, SerializableFunction<T, P> modelToPresentation) {
        super("value", defaultValue, elementPropertyType, presentationToModel, modelToPresentation);
        if (initialValue != null) {
            this.setModelValue(initialValue, false);
            this.setPresentationValue(initialValue);
        }
    }

    public GeneratedVaadinDatePicker(T initialValue, T defaultValue, boolean acceptNullValues) {
        super("value", defaultValue, acceptNullValues);
        if (initialValue != null) {
            this.setModelValue(initialValue, false);
            this.setPresentationValue(initialValue);
        }
    }

    public <P> GeneratedVaadinDatePicker(T initialValue, T defaultValue, Class<P> elementPropertyType, SerializableBiFunction<R, P, T> presentationToModel, SerializableBiFunction<R, T, P> modelToPresentation) {
        super("value", defaultValue, elementPropertyType, presentationToModel, modelToPresentation);
        if (initialValue != null) {
            this.setModelValue(initialValue, false);
            this.setPresentationValue(initialValue);
        }
    }

    public GeneratedVaadinDatePicker() {
        this(null, null, null, (SerializableFunction)null, (SerializableFunction)null);
    }

    public static class OpenedChangeEvent<R extends GeneratedVaadinDatePicker<R, ?>>
    extends ComponentEvent<R> {
        private final boolean opened;

        public OpenedChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
            this.opened = ((GeneratedVaadinDatePicker)((Object)source)).isOpenedBoolean();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }

    public static class InvalidChangeEvent<R extends GeneratedVaadinDatePicker<R, ?>>
    extends ComponentEvent<R> {
        private final boolean invalid;

        public InvalidChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
            this.invalid = ((GeneratedVaadinDatePicker)((Object)source)).isInvalidBoolean();
        }

        public boolean isInvalid() {
            return this.invalid;
        }
    }

    @DomEvent(value="change")
    public static class ChangeEvent<R extends GeneratedVaadinDatePicker<R, ?>>
    extends ComponentEvent<R> {
        public ChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
        }
    }
}

